/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class CustomTextureManager {
    private static CustomTextureManager instance;
    private Map<Integer, String> blockTextures = new HashMap<Integer, String>();
    private Map<Integer, String> itemTextures = new HashMap<Integer, String>();
    private boolean initialized = false;
    public static final int RUBY_ORE_INDEX = 200;
    public static final int RUBY_ITEM_INDEX = 200;

    private CustomTextureManager() {
        this.blockTextures.put(200, "/assets/textures/blocks/ruby_ore.png");
        this.itemTextures.put(200, "/assets/textures/items/ruby.png");
    }

    public static CustomTextureManager getInstance() {
        if (instance == null) {
            instance = new CustomTextureManager();
        }
        return instance;
    }

    public void injectBlockTextures(BufferedImage bufferedImage) {
        for (Map.Entry<Integer, String> entry : this.blockTextures.entrySet()) {
            int n2 = entry.getKey();
            String string = entry.getValue();
            try {
                InputStream inputStream = CustomTextureManager.class.getResourceAsStream(string);
                if (inputStream == null) continue;
                BufferedImage bufferedImage2 = ImageIO.read(inputStream);
                inputStream.close();
                int n3 = n2 % 16 * 16;
                int n4 = n2 / 16 * 16;
                if (n4 + 16 > bufferedImage.getHeight() || n3 + 16 > bufferedImage.getWidth()) continue;
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage(bufferedImage2, n3, n4, 16, 16, null);
                graphics.dispose();
            }
            catch (Exception exception) {
                System.out.println("Failed to load custom block texture: " + string);
                exception.printStackTrace();
            }
        }
    }

    public void injectItemTextures(BufferedImage bufferedImage) {
        for (Map.Entry<Integer, String> entry : this.itemTextures.entrySet()) {
            int n2 = entry.getKey();
            String string = entry.getValue();
            try {
                InputStream inputStream = CustomTextureManager.class.getResourceAsStream(string);
                if (inputStream == null) continue;
                BufferedImage bufferedImage2 = ImageIO.read(inputStream);
                inputStream.close();
                int n3 = n2 % 16 * 16;
                int n4 = n2 / 16 * 16;
                if (n4 + 16 > bufferedImage.getHeight() || n3 + 16 > bufferedImage.getWidth()) continue;
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage(bufferedImage2, n3, n4, 16, 16, null);
                graphics.dispose();
            }
            catch (Exception exception) {
                System.out.println("Failed to load custom item texture: " + string);
                exception.printStackTrace();
            }
        }
    }

    public boolean hasBlockTexture(int n2) {
        return this.blockTextures.containsKey(n2);
    }

    public boolean hasItemTexture(int n2) {
        return this.itemTextures.containsKey(n2);
    }
}

